$(function() {
	menu.init();
});

var menu = {};

menu.getId = function() {
//	return $('#menu ul').attr('sourceId');
	return parseInt(utils.parseUrl().id);
};

menu.isTextSelected = function() {
//	return $('#menu ul').attr('sourceId');
	return parseInt(utils.parseUrl().isTextSelected);
};

menu.init = function() {
	$(document.body).bind('keydown', function() {		
		if(event.keyCode == 65 && event.ctrlKey) {
			event.preventDefault();
		}
	});	

//	var type = menu.getType();
	var id = menu.getId();
//	alert(location.href);
	// 从浏览器 获取数据
	browser.skin.menu.init(id);
};

menu.build = function(menuData) {
	var isTextSelected = menu.isTextSelected();

	// disable button
	if(!isTextSelected) {
		$('#copy-tab, #undo, #cut, #copy, #paste, #delete').addClass('disabled');
	} else {
		$('#select-all').click(function() {
			menu.callSkinFunction("addressbar.selectAllInput()");
		});

		$('#delete').click(function() {
			menu.callSkinFunction("addressbar.deleteInput()");
		});

		$('#copy').click(function() {
			menu.callSkinFunction("addressbar.copyInput()");			
		});
		
		$('#paste').click(function() {
			menu.callSkinFunction("addressbar.pasteInput()");
		});
		
		$('#cut').click(function() {
			menu.callSkinFunction("addressbar.cutInput()");
		});	
		
		$('#undo').click(function() {
			menu.callSkinFunction("addressbar.undoInput()");
		});
		
		$('#copy-tab').click(function() {
			menu.callSkinFunction("addressbar.copyTab()");
		});	
	}

//	alert(location.href);
	var menuSize = view.getSize('menu');
	var menuId = menu.getId();
//	return [menuSize.width, menuSize.height];
	qqbrowser.skin.menu.show(menuId, menuSize.width, menuSize.height);
};

menu.callSkinFunction = function(functionName) {
	try {
		var pageList = qqbrowser.extension.getPages(qqbrowser.window.currentId(), ["foreground"]);
		pageList[0].executeScript("", functionName);	
	} catch(e) {
//		alert(e.message);
	}
};